#include "lvgl_v8.h"


rt_err_t lvgl_v8_init(void)
{

    rt_err_t ret = RT_EOK;

    /* init littlevGL */
    ret = littlevgl2rtt_init("lcd");
    if (ret != RT_EOK)
    {
        return ret;
    }
    lv_ex_data_pool_init();

    return RT_EOK;
}


TF_JPG_display_t jpg_display;   // JPG显示结构体

void TF_JPG_display(void *parameter)
{   
    jpg_display.img_obj = lv_img_create(lv_scr_act());
    while (1)
    {
        for(int i = 5; i >= 1; i--) 
        {
            /* Assuming a File system is attached to letter 'A'
            * E.g. set LV_USE_FS_STDIO 'A' in lv_conf.h */
            rt_snprintf(jpg_display.file_path, sizeof(jpg_display.file_path), 
                        "A:/picture/TF_%d.jpg",
                            i);

            lv_img_set_src(jpg_display.img_obj, jpg_display.file_path);

            const void * src = lv_img_get_src(jpg_display.img_obj);
            lv_img_decoder_get_info(src, &jpg_display.img_header);

            lv_coord_t width = jpg_display.img_header.w;
            lv_coord_t height = jpg_display.img_header.h;

            lv_obj_set_pos(jpg_display.img_obj, (LCD_WIDTH - width) / 2 , (LCD_HEIGHT - height) / 2); // 居中显示

            rt_thread_mdelay(2000);
        }
    }
}