#include "rtthread.h"
#include "bf0_hal.h"
#include "drv_io.h"
#include "./LVGL/lvgl_v8.h"
#include "mem_section.h"  //L2_RET_BSS_SECT

#define TF_JPG_THREAD_STACK_SIZE (2048)

static uint32_t tf_jpg_thread_stack[TF_JPG_THREAD_STACK_SIZE / sizeof(uint32_t)] L2_RET_BSS_SECT(tf_jpg_thread_stack);


static struct rt_thread tf_jpg_thread;
/**
  * @brief  Main program
  * @param  None
  * @retval 0 if success, otherwise failure number
  */
int main(void)
{
    rt_uint32_t ms;

    lvgl_v8_init();     // Initialize LVGL


    rt_err_t tf_jpg_thread_result = rt_thread_init(&tf_jpg_thread,    
                                                    "TF_JPG",          
                                                    TF_JPG_display,
                                                    NULL,              
                                                    &tf_jpg_thread_stack[0], 
                                                    TF_JPG_THREAD_STACK_SIZE, 
                                                    20,                
                                                    10);               
    if (tf_jpg_thread_result == RT_EOK)
    {
        rt_thread_startup(&tf_jpg_thread); // 启动
    }
    else
    {
        rt_kprintf("Failed to init TF_JPG thread\n");
    }

    while (1)
    {
        ms = lv_task_handler();
        rt_thread_mdelay(ms);
    }
    return RT_EOK;

}
